import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ url }) {
  try {
    const email = url.searchParams.get('email') || 'ahmad@smktanjung.ac.id';

    // Cek di users
    const [users] = await db.query(
      'SELECT id, fullName, email, role, password, major, status FROM users WHERE email = ?',
      [email]
    );

    // Cek di students
    const [students] = await db.query(
      'SELECT id, nis, fullName, email, major, status FROM students WHERE email = ?',
      [email]
    );

    return json({
      email,
      user: users.length > 0 ? users[0] : null,
      student: students.length > 0 ? students[0] : null,
      canLoginWith: {
        passwordFromUsers: users.length > 0 ? users[0].password : null,
        nisFromStudents: students.length > 0 ? students[0].nis : null
      }
    });
  } catch (error) {
    console.error('Test error:', error);
    return json({ error: error.message }, { status: 500 });
  }
}

