import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [subjects] = await db.query('SELECT * FROM subjects ORDER BY type, major, name');
    return json({ success: true, data: subjects });
  } catch (error) {
    console.error('Get subjects error:', error);
    return json({ error: 'Gagal mengambil data mata pelajaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { name, type, major, description } = data;

    if (!name) {
      return json({ error: 'Nama mata pelajaran wajib diisi' }, { status: 400 });
    }

    const [result] = await db.query(
      `INSERT INTO subjects (name, type, major, description)
       VALUES (?, ?, ?, ?)`,
      [name.trim(), type || 'core', major || null, description || null]
    );

    return json({
      success: true,
      message: 'Mata pelajaran berhasil ditambahkan',
      data: { id: result.insertId, ...data }
    });
  } catch (error) {
    console.error('Create subject error:', error);
    if (error.code === 'ER_DUP_ENTRY') {
      return json({ error: 'Mata pelajaran dengan nama tersebut sudah ada' }, { status: 400 });
    }
    return json({ error: 'Gagal menambahkan mata pelajaran' }, { status: 500 });
  }
}
