import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [assignments] = await db.query('SELECT * FROM subjectAssignments ORDER BY class, studentId, subject');
    return json({ success: true, data: assignments });
  } catch (error) {
    console.error('Get subject assignments error:', error);
    return json({ error: 'Gagal mengambil data penugasan mata pelajaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { studentId, subject, class: className, teacher } = data;

    if (!studentId || !subject) {
      return json({ error: 'ID Siswa dan Mata Pelajaran wajib diisi' }, { status: 400 });
    }

    const [result] = await db.query(
      `INSERT INTO subjectAssignments (studentId, subject, class, teacher)
       VALUES (?, ?, ?, ?)`,
      [studentId, subject.trim(), className || null, teacher || null]
    );

    return json({
      success: true,
      message: 'Penugasan mata pelajaran berhasil ditambahkan',
      data: { id: result.insertId, ...data }
    });
  } catch (error) {
    console.error('Create subject assignment error:', error);
    return json({ error: 'Gagal menambahkan penugasan mata pelajaran' }, { status: 500 });
  }
}
