import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [schedules] = await db.query('SELECT * FROM schedules ORDER BY class, day, time');
    return json({ success: true, data: schedules });
  } catch (error) {
    console.error('Get schedules error:', error);
    return json({ error: 'Gagal mengambil data jadwal' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { class: className, day, time, subject, teacher, room, year, semester } = data;

    if (!className || !day || !time || !subject || !teacher) {
      return json({ error: 'Kelas, Hari, Waktu, Mata Pelajaran, dan Guru wajib diisi' }, { status: 400 });
    }

    const [result] = await db.query(
      `INSERT INTO schedules (class, day, time, subject, teacher, room, year, semester)
       VALUES (?, ?, ?, ?, ?, ?, ?, ?)`,
      [className.trim(), day.trim(), time.trim(), subject.trim(), teacher.trim(), room || null, year || null, semester || null]
    );

    return json({
      success: true,
      message: 'Jadwal berhasil ditambahkan',
      data: { id: result.insertId, ...data }
    });
  } catch (error) {
    console.error('Create schedule error:', error);
    return json({ error: 'Gagal menambahkan jadwal' }, { status: 500 });
  }
}
